"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _lodash = require("lodash");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function _default(originalHeaders, headersToKeep) {
  const normalizeHeader = function (header) {
    if (!header) return '';
    return header.toString().trim().toLowerCase();
  };
  return (0, _lodash.pick)(originalHeaders, headersToKeep.map(normalizeHeader));
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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